import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import CompanyGallerySlider from "@/components/CompanyGallerySlider";
import { 
  Factory, 
  Shield, 
  Clock, 
  Truck, 
  CheckCircle, 
  Phone,
  Users,
  Award,
  Target,
  Building2
} from "lucide-react";
import Link from "next/link";

export default function AboutPage() {
  const values = [
    {
      icon: <Target className="h-8 w-8" />,
      title: "Our Mission",
      description: "To Provide Innovative Solutions Matching to Latest Trends"
    },
    {
      icon: <Award className="h-8 w-8" />,
      title: "Quality Commitment",
      description: "High level quality and safety in our manufacturing process"
    },
    {
      icon: <Users className="h-8 w-8" />,
      title: "Expert Team",
      description: "Team of experts with extensive experience in portable buildings"
    },
    {
      icon: <Shield className="h-8 w-8" />,
      title: "Safety Standards",
      description: "Fire security, insulation, and weather-resistant designs"
    }
  ];

  const capabilities = [
    "Office Porta Cabins with attached bathrooms and pantry",
    "Security Cabins for 1, 2, or 3 person occupancy",
    "Toilet Units from single units to customized up to 20",
    "Double story Porta Cabins for increased capacity",
    "Custom portable building solutions",
    "Insulation and climate control systems",
    "Fire safety and security features",
    "Professional installation services"
  ];

  const features = [
    "Insulated construction for UAE climate",
    "Fire security systems",
    "Doors and windows with quality fittings",
    "Vinyl flooring installation",
    "Split system air conditioner ready",
    "Kitchenette with zip hot water system",
    "Bathroom with partition walls",
    "Economical designs with quality furnishings"
  ];

  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-r from-blue-900/80 to-gray-900/80">
        <div className="absolute inset-0 bg-black/40"></div>
        <div className="absolute inset-0">
          <div className="w-full h-full bg-gradient-to-br from-blue-800 via-gray-800 to-slate-800"></div>
        </div>
        
        <div className="relative z-20 container mx-auto px-4 text-center text-white">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">
            ABOUT US
          </h1>
          <p className="text-xl md:text-2xl max-w-3xl mx-auto">
            Safe Industry Solutions in House Production
          </p>
        </div>
      </section>

      {/* Company Overview */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
              SAAM CABINS - Leading Porta Cabin Solutions
            </h2>
            <p className="text-lg text-gray-700 leading-relaxed mb-6">
              SAAM CABINS have an extensive range of standard cabins that can be constructed to your specifications. 
              We offer an extensive range of Porta Cabin ablution units, site offices, security cabins, porta cabin toilets, 
              and portable toilets in different standard pre-designed units to choose from, with economical designs and quality 
              fitting and furnishings.
            </p>
            <p className="text-lg text-gray-700 leading-relaxed">
              We pride ourselves in our ability to design and create affordable, customized and environmentally friendly 
              portable buildings as well as professional requirements. This is why we continue to lead the way in modular buildings.
            </p>
          </div>

          {/* Values Grid */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {values.map((value, index) => (
              <div key={index} className="text-center">
                <div className="bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <div className="text-blue-600">
                    {value.icon}
                  </div>
                </div>
                <h3 className="text-xl font-semibold text-gray-900 mb-2">
                  {value.title}
                </h3>
                <p className="text-gray-600">
                  {value.description}
                </p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Manufacturing Capabilities */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                Manufacturing Excellence
              </h2>
              <p className="text-lg text-gray-700 mb-6">
                Our manufacturing unit based in Sharjah has been supplying and manufacturing porta cabins 
                across UAE. We maintain high level quality and safety in our manufacturing process, whether 
                you need a security porta cabin or double story porta cabin.
              </p>
              
              <div className="space-y-3">
                <h3 className="text-xl font-semibold text-gray-900 mb-4">Our Capabilities:</h3>
                {capabilities.map((capability, index) => (
                  <div key={index} className="flex items-start space-x-3">
                    <CheckCircle className="h-5 w-5 text-blue-600 mt-0.5 flex-shrink-0" />
                    <span className="text-gray-700">{capability}</span>
                  </div>
                ))}
              </div>
            </div>

            <div className="grid grid-cols-2 gap-4">
              <Card className="p-6 text-center bg-blue-50">
                <Factory className="h-12 w-12 text-blue-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">Manufacturing</h3>
                <p className="text-gray-600">In-house production facility in Sharjah</p>
              </Card>
              <Card className="p-6 text-center bg-green-50">
                <Truck className="h-12 w-12 text-green-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">Delivery</h3>
                <p className="text-gray-600">UAE-wide supply and installation</p>
              </Card>
              <Card className="p-6 text-center bg-orange-50">
                <Clock className="h-12 w-12 text-orange-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">Quick Turnaround</h3>
                <p className="text-gray-600">Built to order within few days</p>
              </Card>
              <Card className="p-6 text-center bg-purple-50">
                <Building2 className="h-12 w-12 text-purple-600 mx-auto mb-4" />
                <h3 className="text-lg font-semibold text-gray-900 mb-2">Custom Design</h3>
                <p className="text-gray-600">Tailored to your specifications</p>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Company Gallery */}
      <section className="py-16 bg-gray-100">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Our Facilities & Work Environment
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Take a look at our manufacturing facility, quality control processes, and the professional 
              environment where we create premium porta cabin solutions.
            </p>
          </div>
          
          <div className="max-w-6xl mx-auto">
            <CompanyGallerySlider 
              images={[
                {
                  id: '1',
                  title: 'Manufacturing Facility',
                  description: 'Our state-of-the-art production facility in Sharjah',
                  image: '/uploads/manufacturing-facility.jpg',
                  category: 'Facility',
                  isActive: true,
                  order: 1,
                  createdAt: new Date().toISOString(),
                  updatedAt: new Date().toISOString()
                },
                {
                  id: '2',
                  title: 'Quality Control',
                  description: 'Rigorous quality checks ensure premium standards',
                  image: '/uploads/quality-control.jpg',
                  category: 'Quality',
                  isActive: true,
                  order: 2,
                  createdAt: new Date().toISOString(),
                  updatedAt: new Date().toISOString()
                },
                {
                  id: '3',
                  title: 'Team at Work',
                  description: 'Skilled professionals crafting your portable buildings',
                  image: '/uploads/team-work.jpg',
                  category: 'Team',
                  isActive: true,
                  order: 3,
                  createdAt: new Date().toISOString(),
                  updatedAt: new Date().toISOString()
                },
                {
                  id: '4',
                  title: 'Installation Process',
                  description: 'Professional on-site installation and setup',
                  image: '/uploads/installation.jpg',
                  category: 'Installation',
                  isActive: true,
                  order: 4,
                  createdAt: new Date().toISOString(),
                  updatedAt: new Date().toISOString()
                }
              ]}
              autoPlay={true}
              autoPlayDelay={6000}
              className="mb-8"
            />
          </div>
        </div>
      </section>

      {/* Features & Quality */}
      <section className="py-16 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Quality Features & Specifications
            </h2>
            <p className="text-lg text-gray-600 max-w-2xl mx-auto">
              Our porta cabins are fabricated in our factory with premium features and quality components 
              designed for the UAE climate and professional requirements.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-4xl mx-auto">
            {features.map((feature, index) => (
              <div key={index} className="flex items-center space-x-3">
                <Badge className="bg-blue-100 text-blue-800 hover:bg-blue-200">
                  <CheckCircle className="h-4 w-4 mr-2" />
                  Included
                </Badge>
                <span className="text-gray-700">{feature}</span>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-blue-800 text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Ready for Your Porta Cabin Solution?
          </h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            If you're looking for a temporary low cost porta cabin solution, check out our range. 
            These units are affordable, practical, comfortable and extremely secure.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button size="lg" className="bg-white text-blue-800 hover:bg-gray-100 px-8">
              <Phone className="mr-2 h-5 w-5" />
              Call: +971 58 201 2073
            </Button>
            <Button size="lg" variant="outline" className="border-white text-white hover:bg-white/10 px-8" asChild>
              <Link href="/contact">
                Get Quote Today
              </Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  );
}